
/****** Object:  StoredProcedure [dbo].[P_EST_FECHA_PROC_MOV_EST_PROD_CPL_REPROC_CUSTO]    Script Date: 12/19/2013 17:34:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_FECHA_PROC_MOV_EST_PROD_CPL_REPROC_CUSTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_EST_PROD_CPL_REPROC_CUSTO]
GO

CREATE PROCEDURE [dbo].[P_EST_FECHA_PROC_MOV_EST_PROD_CPL_REPROC_CUSTO](@CD_EMP INT=1,@CD_FILIAL INT, @CD_PROD INT=0)
AS

set nocount on;
--Versao 2455
DECLARE  @DT_REF AS DATETIME
DECLARE  @CD_PROD_CURSOR AS INT
DECLARE  @VLR_CUSTO_GER AS MONEY
DECLARE  @VLR_CUSTO_MD AS MONEY
DECLARE  @VLR_CUSTO AS MONEY


/*****************************************************************************************************************************/
--Relacao produtos
/*****************************************************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#RsProd_Cpl') IS NOT NULL
	BEGIN
		 DROP TABLE #RsProd_Cpl
	END


	CREATE TABLE #RsProd_Cpl(CD_EMP INT,
								CD_FILIAL INT,
								CD_PROD INT )  

/*****************************************************************************************************************************/

	SET @DT_REF = CONVERT(DATE ,GETDATE() )
	 
	DECLARE @NMTBL VARCHAR(100), @CMD VARCHAR(200);
	SET @NMTBL = 'EST_FECHA_PROC_MOV_PEND_TBL_PROC_' +CONVERT(VARCHAR,@CD_FILIAL);

	IF NOT OBJECT_ID(@NMTBL) IS NULL
	BEGIN
				
		SET @CMD = 'INSERT INTO #RsProd_Cpl(CD_EMP, CD_FILIAL, CD_PROD)
					SELECT  DISTINCT CD_EMP, CD_FILIAL, CD_PROD
					FROM ' + @NMTBL + ' WHERE CD_EMP= ' + convert(varchar,@CD_EMP)
		SET @CMD = @CMD+ ' AND CD_FILIAL =' + convert(varchar,@CD_FILIAL) 

		EXEC (@CMD);
	END 

	IF @CD_PROD > 0 
	BEGIN
		delete from #RsProd_Cpl
		INSERT INTO #RsProd_Cpl(CD_EMP, CD_FILIAL, CD_PROD)
		SELECT @CD_EMP, @CD_FILIAL, @CD_PROD
	END
	--select * from #RsProd_Cpl
	if not exists(select top 1 cd_emp from #RsProd_Cpl)
	begin
		INSERT INTO #RsProd_Cpl(CD_EMP, CD_FILIAL, CD_PROD)
		select CD_EMP, CD_FILIAL, CD_PROD
		from 
			est_prod_cpl
		where
			cd_emp =@CD_EMP
			and cd_filial = @CD_FILIAL
	end
		
	CREATE UNIQUE CLUSTERED INDEX ix_RsProd_Cpl ON #RsProd_Cpl (CD_PROD,CD_FILIAL,CD_EMP);			
	 

	
	PRINT 'Filial.: ' + CONVERT(VARCHAR, @CD_FILIAL)  +  ' aplicando custo no produto complemento ' + CONVERT(VARCHAR, GETDATE (),108)     
/*****************************************************************************************************************************/
	DECLARE cProd CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT
		c.CD_PROD,
		dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (C.CD_EMP,C.CD_FILIAL,C.CD_PROD,@DT_REF,1) VLR_CUSTO_GER,
		dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (C.CD_EMP,C.CD_FILIAL,C.CD_PROD,@DT_REF,0) VLR_CUSTO_MD,
		dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (C.CD_EMP,C.CD_FILIAL,C.CD_PROD,@DT_REF,6) VLR_CUSTO
	FROM
		EST_PROD_CPL C
		inner join #RsProd_Cpl p on  
		c.CD_EMP	 = P.CD_EMP AND
		c.CD_FILIAL  = P.CD_FILIAL AND
		c.CD_PROD	 = P.CD_PROD
	WHERE
		C.CD_EMP = @CD_EMP
		AND C.CD_FILIAL=@CD_FILIAL
	ORDER BY 
		C.CD_PROD
	
	
	OPEN cProd
	FETCH NEXT FROM cProd INTO @CD_PROD_CURSOR, @VLR_CUSTO_GER, @VLR_CUSTO_MD, @VLR_CUSTO;

	WHILE @@FETCH_STATUS=0
	BEGIN
		--PRINT 'Produto ' + convert(varchar,@CD_PROD_CURSOR);
		--print @VLR_CUSTO_MD
		IF EXISTS( SELECT TOP 1 CD_EMP FROM
						EST_PROD_CPL C
							WHERE
								C.CD_EMP = @CD_EMP
								AND C.CD_FILIAL=@CD_FILIAL
								AND C.CD_PROD = @CD_PROD_CURSOR
			
								AND (VLR_CUSTO_GER  <> @VLR_CUSTO_GER
										OR VLR_CUSTO_MD <> @VLR_CUSTO_MD
										OR VLR_CUSTO <> @VLR_CUSTO ))
		BEGIN 
			
			UPDATE 
				C 
			SET 
				VLR_CUSTO_GER   = @VLR_CUSTO_GER,
				VLR_CUSTO_MD    = @VLR_CUSTO_MD,
				VLR_CUSTO		= @VLR_CUSTO,
				VLR_CUSTO_MD_FLUTUANTE = @VLR_CUSTO_MD
			FROM
				EST_PROD_CPL C
			WHERE
				C.CD_EMP = @CD_EMP
				AND C.CD_FILIAL=@CD_FILIAL
				AND C.CD_PROD = @CD_PROD_CURSOR
			
				AND (VLR_CUSTO_GER  <> @VLR_CUSTO_GER
						OR VLR_CUSTO_MD <> @VLR_CUSTO_MD
						OR VLR_CUSTO <> @VLR_CUSTO );
		END	
		FETCH NEXT FROM cProd INTO @CD_PROD_CURSOR, @VLR_CUSTO_GER, @VLR_CUSTO_MD, @VLR_CUSTO;
		
	END
	CLOSE cProd
	DEALLOCATE cProd

	IF  OBJECT_ID('TEMPDB.DBO.#RsProd_Cpl') IS NOT NULL
	BEGIN
		 DROP TABLE #RsProd_Cpl
	END